/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: ConfigLockDlg.cpp $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 26.07.06 10:19 $
    $Revision: 1353 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Configuration Lock Get/Set Test dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        25.07.2006  MT       initial version
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file ConfigLockeDlg.cpp
///   Configuration Lock Get/Set Test dialog
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "ConfigLockDlg.h"
#include "cifXTestDlg.h"

#define DEFAULT_SETLOCK_TIMEOUT  2000

/////////////////////////////////////////////////////////////////////////////
/// Lock state elements for list control
/////////////////////////////////////////////////////////////////////////////
static struct CONFIG_LOCKtag
{
  LPCTSTR       szState;  //!< State to display in control
  unsigned long ulState;  //!< State value for element
} s_atConfigLockStates[] =
{
  {_T("CONFIG_LOCK"),   CIFX_CONFIGURATION_LOCK},
  {_T("CONFIG_UNLOCK"), CIFX_CONFIGURATION_UNLOCK},
};

IMPLEMENT_DYNAMIC(CConfigLockDlg, CBaseDialog)

/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
///   \param pParent Parent Window
/////////////////////////////////////////////////////////////////////////////
CConfigLockDlg::CConfigLockDlg(CWnd* pParent /*=NULL*/)
: CBaseDialog(CConfigLockDlg::IDD, pParent, false)
, m_ulSetTimeout(DEFAULT_SETLOCK_TIMEOUT)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CConfigLockDlg::~CConfigLockDlg()
{
}

/////////////////////////////////////////////////////////////////////////////
/// DDX/DDV support
///   \param pDX 
/////////////////////////////////////////////////////////////////////////////
void CConfigLockDlg::DoDataExchange(CDataExchange* pDX)
{
	CBaseDialog::DoDataExchange(pDX);

  DDX_Control(pDX, IDC_CB_NEWSTATE, m_cNewStateCtrl);
}


BEGIN_MESSAGE_MAP(CConfigLockDlg, CBaseDialog)
  ON_BN_CLICKED(IDC_BTN_GETSTATE, OnBnClickedBtnGetstate)
  ON_BN_CLICKED(IDC_BTN_SETSTATE, OnBnClickedBtnSetstate)
  ON_EN_KILLFOCUS(IDC_EDT_TIMEOUT, OnEnKillfocusEdtTimeout)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
/// Button "Get Lock State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CConfigLockDlg::OnBnClickedBtnGetstate()
{
  uint32_t ulActState = 0;

  int32_t lRet = CcifXTestDlg::s_pcDevice->ConfigLock(CIFX_CONFIGURATION_GETLOCKSTATE, &ulActState, m_ulSetTimeout);

  CString csError;
  if(CIFX_NO_ERROR != lRet)
  {
    csError.Format(_T("0x%08X\r\n%s"),
                   lRet,
                   (LPCTSTR)CcifXTestDlg::s_pcDevice->GetErrorDescription(lRet));

  } else
  {
    CString csState;

    switch(ulActState)
    {
    case CIFX_CONFIGURATION_LOCK:
      csState = _T("CONFIG LOCKED");
      break;

    case CIFX_CONFIGURATION_UNLOCK:
      csState = _T("CONFIG NOT LOCKED");
      break;

    default:
      csState = _T("Illegal Config Lock State");
      break;
    }

    SetDlgItemText(IDC_EDT_ACTSTATE, csState);
  }
  SetDlgItemText(IDC_LASTERR, csError);

}

/////////////////////////////////////////////////////////////////////////////
/// Button "Set Lock State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CConfigLockDlg::OnBnClickedBtnSetstate()
{
  int iItem = m_cNewStateCtrl.GetCurSel();
  ASSERT(-1 != iItem);

  CWaitCursor cWait;

  uint32_t ulNewState = (uint32_t)m_cNewStateCtrl.GetItemData(iItem);
  uint32_t ulTemp     = 0;

  int32_t lRet = CcifXTestDlg::s_pcDevice->ConfigLock(ulNewState, &ulTemp, m_ulSetTimeout);

  CString csError;
  if(CIFX_NO_ERROR != lRet)
  {
    csError.Format(_T("0x%08X\r\n%s"),
                   lRet,
                   (LPCTSTR)CcifXTestDlg::s_pcDevice->GetErrorDescription(lRet));

  }
  SetDlgItemText(IDC_LASTERR, csError);
}

/////////////////////////////////////////////////////////////////////////////
/// Set Lock State Timeout editing end event
/////////////////////////////////////////////////////////////////////////////
void CConfigLockDlg::OnEnKillfocusEdtTimeout()
{
  CString csTemp;
  GetDlgItemText(IDC_EDT_TIMEOUT, csTemp);

  TCHAR* pszEnd = NULL;
  m_ulSetTimeout = _tcstoul(csTemp, &pszEnd, 10);

  csTemp.Format(_T("%u"), m_ulSetTimeout);
  SetDlgItemText(IDC_EDT_TIMEOUT, csTemp);
}

/////////////////////////////////////////////////////////////////////////////
/// First Time dialog initialization
///   \return TRUE
/////////////////////////////////////////////////////////////////////////////
BOOL CConfigLockDlg::OnInitDialog()
{
  CBaseDialog::OnInitDialog();

  SetDlgItemInt(IDC_EDT_TIMEOUT, m_ulSetTimeout, FALSE);

  for(int iIdx = 0; iIdx < sizeof(s_atConfigLockStates) / sizeof(s_atConfigLockStates[0]); ++iIdx)
  {
    int iItem = m_cNewStateCtrl.AddString(s_atConfigLockStates[iIdx].szState);
    m_cNewStateCtrl.SetItemData(iItem, s_atConfigLockStates[iIdx].ulState);
  }

  m_cNewStateCtrl.SetCurSel(0);

  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
/// Cyclic Thread function, stubbed out, as we don't have any cyclic actions
/////////////////////////////////////////////////////////////////////////////
void CConfigLockDlg::ThreadFunction(void)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Device changed notification
/////////////////////////////////////////////////////////////////////////////
void CConfigLockDlg::OnUpdateDevice(CCifXDeviceBase* /*pcDevice*/)
{
}
